require "ISUI/ISUIElement"

EPIIPanel = ISUIElement:derive("EPIIPanel");

function EPIIPanel:new(x, y, width, height, zoom, iconWidth, iconHeight, maxColumns, maxRows, useMoreIcon)
	local o = {}

	o = ISUIElement:new(x, y, width, height);
	setmetatable(o, self)
    self.__index = self
	
	o.x = x;
	o.y = y;
	
	o.width = width;
	o.height = height;
	
	o.iw = iconWidth
	o.ih = iconHeight
	
	o.xpad = 5
	o.ypad = 5
	
	o.maxX = maxColumns
	o.maxY = maxRows
	
	o.useMoreIcon = useMoreIcon
	o.usePanelBackgroundTex = false
	o.useIconHighlight = true
	
	o.anchorLeft = true;
	o.anchorRight = false;
	o.anchorTop = true;
	o.anchorBottom = false;
	
    o.zoom = zoom;
	
	o.texturesToRender = {};

	o.neededWidth = 0;
	o.maxIconHeight = 0;
	
	o.borderColor = {r=1, g=1, b=1, a=1};
	o.backgroundColor = {r=0.1, g=0.1, b=0.1, a=0.5};
	o.iconColor = {r=1, g=1, b=1, a=0.7};
	o.iconHighlightColor = {r=1, g=1, b=1, a=0.85};

    o.favoriteStar = getTexture("media/ui/FavoriteStar.png");
	o.moreIcon = getTexture("media/ui/EPII_moreIcon.png");
	o.panelTex = getTexture("media/ui/EPII_panel.png");
	o.iconHighlightTex = getTexture("media/ui/EPII_iconHighlight.png");
	
	o.background = true;
	o.anchorLeft = true;
	o.anchorRight = false;
	o.anchorTop = true;
	o.anchorBottom = false;
    o.moveWithMouse = false;
	
   return o
end

function EPIIPanel:setIconSize(iconSize)
	self.iw = iconSize
	self.ih = iconSize
end

function EPIIPanel:setIconAlpha(iconAlpha)
	self.iconColor.a = math.min(1.0, math.max(0.0, iconAlpha))
end

function EPIIPanel:setPanelDimensions(maxColumns, maxRows)
	self.maxX = maxColumns
	self.maxY = maxRows
end

function EPIIPanel:setUseMoreIcon(useMoreIcon)
	self.useMoreIcon = useMoreIcon
end

function EPIIPanel:setUseIconHighlight(useIconHighlight)
	self.useIconHighlight = useIconHighlight
end

function EPIIPanel:setUsePanelBackgroundTex(usePanelTex)
	self.usePanelBackgroundTex = usePanelTex
end

function EPIIPanel:setIconPadding(xPad, yPad)
	self.xpad = xPad
	self.ypad = yPad
end

--[[
function EPIIPanel:initialise()
	ISUIElement.initialise(self);
end
]]

	
-- TODO: Investigate using this for scrolling through the icons
--[[
function EPIIPanel:onMouseWheel(delta)
 
	if self.inventoryPage.isCollapsed then return false; end
	local yScroll = self.smoothScrollTargetY or self:getYScroll()
	local topRow = self:rowAt(0, -yScroll)
	if self.items[topRow] then
		if not self.smoothScrollTargetY then self.smoothScrollY = self:getYScroll() end
		local y = self:topOfItem(topRow)
		if del < 0 then
			if yScroll == -y and topRow > 1 then
				y = self:topOfItem(topRow - 1)
			end
			self.smoothScrollTargetY = -y;
		else
			self.smoothScrollTargetY = -(y + self.itemHgt);
		end
	else
		self:setYScroll(self:getYScroll() - (del*9));
	end
    return true;


	return true
end
]]

function EPIIPanel:close()
	self:reset()
	
	self:setVisible(false)
end

function EPIIPanel:isFull()
	-- We use the more icon when there are more icons than we can display, but we only know
	--   that we have more than we can display when we have already exceeded our capacity.
	if self.useMoreIcon then
		return #self.texturesToRender >= ((self.maxX * self.maxY) + 1)
	else
		return #self.texturesToRender >= (self.maxX * self.maxY)
	end
end

function EPIIPanel:addIcon(newTex)
	if self.useMoreIcon and #self.texturesToRender >= (self.maxX * self.maxY) then
		-- We are already at capacity and we have just had another icon added. We now know 
		--   that the previous icon should be the moreIcon. Set that.
		self.texturesToRender[self.maxX * self.maxY] = self.moreIcon
		
		-- We still need to add the current icon to the table so that we know that the 
		--   capacity is already exceeded.
		newTex = self.moreIcon
	end
	
	table.insert(self.texturesToRender, newTex)
end

function EPIIPanel:prerender()
	if self:isEmpty() then
		self:setX(100000)
		return;
	end
	
	-- Calculate the needed panel dimensions
	local iconCount = #self.texturesToRender
	local neededX = math.min(iconCount, self.maxX)
	local neededY = math.min(self.maxY, math.floor(0.999 + iconCount / neededX))

	self.width = self.xpad + (neededX * (self.iw + self.xpad))
	self.height = self.ypad + (neededY * (self.ih + self.ypad))
end

function EPIIPanel:rendericons(ulX, ulY)
	local xcount = 0;
	local ycount = 0;
	
    for _,curTex in pairs(self.texturesToRender) do
        local itemTex = curTex
		
		if self.useIconHighlight and curTex ~= self.moreIcon then
			self:drawTextureScaled(self.iconHighlightTex, ulX + self.xpad + (xcount * (self.iw + self.xpad)), ulY + self.ypad + (ycount * (self.ih + self.ypad)), self.iw, self.ih, self.iconHighlightColor.a, self.iconHighlightColor.r, self.iconHighlightColor.g, self.iconHighlightColor.b);
		end

		self:drawTextureScaled(itemTex, ulX + self.xpad + (xcount * (self.iw + self.xpad)), ulY + self.ypad + (ycount * (self.ih + self.ypad)), self.iw, self.ih, self.iconColor.a, self.iconColor.r, self.iconColor.g, self.iconColor.b);

		xcount = xcount + 1;

		if xcount >= self.maxX then
			xcount= 0;
			ycount = ycount + 1;
		end
		
		if ycount >= self.maxY then
			return
		end
	end
end

function EPIIPanel:render()
	if self:isEmpty() then
		return;
	end
	
	self:bringToTop()
    
	local ulX = math.max(0, self.x - math.floor(self.width / 2))
	if (ulX + self.width) > getCore():getScreenWidth() then ulX = getCore():getScreenWidth() - self.width end
	local ulY = math.max(0, self.y - self.height)

	if self.usePanelBackgroundTex then
		self:drawTextureScaled(self.panelTex, ulX, ulY, self.width, self.height, 0.8, 1, 1, 1);
	else
		self:drawRect(ulX, ulY, self.width, self.height, self.backgroundColor.a, self.backgroundColor.r, self.backgroundColor.g, self.backgroundColor.b);
		self:drawRectBorderStatic(ulX, ulY, self.width, self.height, self.borderColor.a, self.borderColor.r, self.borderColor.g, self.borderColor.b)
	end

	if self.iw > 0 then
		self:rendericons(ulX, ulY)
	end
end

function EPIIPanel:reposition(x, y, zoom)
	self.x = x
	self.y = y
	
	self.zoom = zoom
end

function EPIIPanel:isEmpty()
	return #self.texturesToRender <= 0
end

function EPIIPanel:reset()
	self.x = 1
	self.y = 1
	
	self.width = 0
	self.height = 0
	
	self.zoom = 0
	
	self.neededHeight = 0
	self.neededWidth = 0
	
	self.texturesToRender = {}
end
